/*
 * Splits a single "vmtrace" log file into per-<bdev,inode> files.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include "list.h"
#define BITS_PER_LONG 32
#include "hash.h"
#include "vmtrace.h"


int parse_trace_file(void *mptr, int len)
{
	int i;
	struct vm_trace_entry *entry = (struct vm_trace_entry *) mptr;

	for(i = 0; i < len/sizeof(struct vm_trace_entry); i++) {
		printf("entry->seqnr: %x\n", entry->seqnr);
		entry++;
	}
}

int main(int argc, char *argv[])
{
	int fd;
	void *mptr;
	struct stat fstat;

	if (argc != 2) {
		printf("usage: vmtrace-print trace-file\n");
		exit(0);
	}

	if (stat(argv[1], &fstat) < 0) {
		perror("stat");
		exit(0);
	}

	if ((fd = open(argv[1], O_RDONLY)) < 0) {
		perror("open");
		exit(0);
	}

	mptr = mmap(0, fstat.st_size, PROT_READ, MAP_SHARED, fd, 0);

	if (mptr == MAP_FAILED) {
		perror("mmap");
		exit(0);
	}

	parse_trace_file(mptr, fstat.st_size);

	munmap(mptr, fstat.st_size);
	close(fd);
}

