/*
 * Capture vmtrace output from relayfs file
 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <sys/poll.h>
#include "vmtrace.h"

int capture_loop(int infd, int outfd)
{
	struct pollfd pfd;
	void *datapage;
	int pgsize = getpagesize() % (getpagesize() - sizeof(struct vm_trace_entry));

	pfd.fd = infd;
	pfd.events = POLLIN;

	datapage = (void *)malloc(pgsize);
	if (!datapage) {
		printf("error allocating datapage!\n");
		exit(0);
	}

	do  {
		int ret, count, written;

		ret = poll(&pfd, 1, -1);
		if (ret < 0) {
			perror("poll");
			exit(0);
		}

		if (pfd.revents & POLLIN) {
			count = read(infd, datapage, pgsize);
			if (count < 0) {
				perror("read");
				exit(0);
			}
			written = write(outfd, datapage, count);
			if (written < 0) {
				perror("write");
				exit(0);
			}
			if (written < count) {
				printf("write failed! attempt:%d success:%d\n",
					count, written);
				exit(0);
			}
		}
	} while (1);
}

int main(int argc, char *argv[]) 
{
	int infd, outfd;
	void *mptr;

	if (argc != 3) {
		printf("usage: vmtrace-capture relayfs-file output-file\n" );
		exit(0);
	}

	if ((infd = open(argv[1], O_RDONLY)) < 0) {
		printf("failed to open %s\n", argv[1]);
		perror("open");
		exit(0);
	}

	if ((outfd = open(argv[2], O_RDWR|O_CREAT)) < 0) {
		printf("failed to open %s\n", argv[1]);
		perror("open");
		exit(0);
	}

	capture_loop(infd, outfd);

	close(infd);
	close(outfd);
}

