/*
 * Reorganize "vmtrace" log file in "sequence number" order.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include "list.h"
#define BITS_PER_LONG 32
#include "hash.h"
#include "vmtrace.h"

int outfd;

int write_entry(struct vm_trace_entry *entry)
{
	int ret;

	ret = write(outfd, entry, sizeof(struct vm_trace_entry));

	if (ret < 0) {
		printf("error writing\n");
		perror("write");
		return 0;
	}
	return 1;
}

int look_for(unsigned long expected_seqnr, int curpos, 
		struct vm_trace_entry *curentry, int len)
{
	int i;
	struct vm_trace_entry *entry = curentry;

	for (i = curpos ; i < len/sizeof(struct vm_trace_entry); i++) {
		entry++;
		if (entry->seqnr == expected_seqnr) {
			if (!write_entry(entry))
				exit(0);
			return 1;
		}
	}
	return 0;
}

int parse_trace_file(void *mptr, int len)
{
	int i;	
	unsigned long expected_seqnr;
	struct vm_trace_entry *entry = (struct vm_trace_entry *) mptr;

	expected_seqnr = entry->seqnr;

	for(i = 0; i < len/sizeof(struct vm_trace_entry); i++) {
		/* out of expected order ? organize. */
		printf("entry->seqnr:%x\n", entry->seqnr);
		while (entry->seqnr > expected_seqnr) {
			if (!look_for(expected_seqnr, i, entry, len)) {
				printf("can't find seqnr:%x\n", expected_seqnr);
				exit(0);
			}
			expected_seqnr++;
		}
		while (entry->seqnr < expected_seqnr) {
			if (!look_for(expected_seqnr, i, entry, len)) {
				printf("can't find seqnr:%x\n", expected_seqnr);
				exit(0);
			}
			expected_seqnr++;
		}
		if (!write_entry(entry))
			exit(0);
		entry++;
		expected_seqnr++;
	}
}

int main(int argc, char *argv[]) 
{
	int fd;
	void *mptr;
	struct stat fstat;

	if (argc != 3) {
		printf("usage: vmtrace-split trace-file directory\n");
		exit(0);
	}

	if (stat(argv[1], &fstat) < 0) {
		perror("stat");
		exit(0);
	}

	if ((fd = open(argv[1], O_RDONLY)) < 0) {
		perror("open");
		exit(0);
	}

	mptr = mmap(0, fstat.st_size, PROT_READ, MAP_SHARED, fd, 0);

	if (mptr == MAP_FAILED) {
		perror("mmap");	
		exit(0);
	}
	
	if ((outfd = open(argv[2], O_RDWR|O_CREAT)) < 0) {
		perror("open");
		exit(0);
	}
	
	parse_trace_file(mptr, fstat.st_size);

	munmap(mptr, fstat.st_size);
	close(fd);
}

